#ifndef	_DRKTypeManager_
#define	_DRKTypeManager_

class DRKTypeManager;
class DRKLister;
class DRKEditor;

typedef struct openListers;
typedef struct openEditors;
typedef struct addOn;
typedef   DRKLister*(*DRKCreateLister)(BResourceFile* resFile);
typedef   DRKEditor*(*DRKCreateEditor)(BResourceFile* resFile, long index);

extern DRKTypeManager	*gTypeManager;

/*
*	DRKEditor and DRKLister talk to and are managed by DRKTypeManager
*/
class DRKTypeManager : public BObject
{
public:
		DRKTypeManager() {fStartedUp = FALSE;};
virtual ~DRKTypeManager();

	bool RegisterEditor(unsigned long resType, DRKCreateEditor creator);
	bool RegisterLister(unsigned long resType, DRKCreateLister creator);
	
	void OpenTypeEditor(BResourceFile *resFile, unsigned long resType, long id);
	void OpenTypeList(BResourceFile *resFile, unsigned long resType);

	bool CloseEditorReq(DRKEditor *editor);
	bool CloseListReq(DRKLister *lister);
	bool CloseFileReq(BResourceFile *resFile);
	
	void Startup(BWindow* splashScreen);
	void ShutDown();

private:
	void DoGetInfo(BResourceFile *resFile,unsigned long resType, long id);

	openEditors	*FindEditor(BResourceFile *resFile, unsigned long resType, long id);
	openListers	*FindLister(BResourceFile *resFile, unsigned long resType);

	openEditors	*FindEditor(DRKEditor *editor);
	openListers	*FindLister(DRKLister *lister);

	void	SendMessageToAddon(addOn* add_on, BMessage* message);
	void	SendMessageToAddons(BMessage *message);
	
	BList	fAddOns;
	BList	fRegEditors;
	BList	fRegListers;
	BList	fEditors;
	BList	fListers;
	bool	fStartedUp;
};

#endif // _DRKTypeManager_